using System;
using System.Collections;
using System.Collections.Generic;


namespace CSharpRecipes
{
	public partial class IteratorsAndPartialTypes
    {
        #region "6.1 Implementacja zagniedonych ptli foreach dla klasy"
        // ***   Wczeniej 3.27   ***
        public static void CreateNestedObjects()
        {
			Group topLevelGroup = new Group();

            // Utworzenie dwch grup w obrbie obiektu TopLevelSet.
			topLevelGroup.AddGroup("sg1");
			topLevelGroup.AddGroup("sg2");

            // Dodanie dwch obiektw Item dla kadego obiektu SubGroup w ramach obiektu topLevelGroup.
			foreach (SubGroup SG in topLevelGroup)
			{
				SG.AddItem("item1", 100);
				SG.AddItem("item2", 200);
			}

			// Odczytanie danych
			ReadNestedObjects(topLevelGroup);
        }

		private static void ReadNestedObjects(Group topLevelGroup)
        {
			Console.WriteLine("topLevelGroup.Count: " + topLevelGroup.Count);

            // Zewntrzna ptla foreach do przetwarzania obiektw SubGroup
            // w obrbie obiektw topLevelGroup.

			foreach (SubGroup SG in topLevelGroup)
            {
                Console.WriteLine("\tSG.SubGroupName:  " + SG.SubGroupName);
                Console.WriteLine("\tSG.Count: " + SG.Count);

                // Wewntrzna ptla foreach do przetwarzania wszystkich obiektw Item
                // w obrbie biecego obiektu SubGroup.
                foreach (Item I in SG)
				{
					Console.WriteLine("\t\tI.ItemName:     " + I.ItemName);
					Console.WriteLine("\t\tI.ItemLocation: " + I.ItemLocation);
				}
            }
        }


        //----------------------------------------------
        // Klasa pierwszego poziomu
        //----------------------------------------------
        public class Group : IEnumerable
		{
            //KONSTRUKTORY
			public Group() {}

            //POLA
			private List<SubGroup> setArray = new List<SubGroup>();

            //WACIWOCI
			public int Count
			{
				get{return(setArray.Count);}
			}

			//METODY
			public void AddGroup(string name)
			{
				SubGroup subGroup = new SubGroup(name);
				setArray.Add(subGroup);
			}

			public SubGroup GetGroup(int setIndex)
			{
				return(setArray[setIndex]);
			}

			IEnumerator IEnumerable.GetEnumerator()
			{
				for (int index = 0; index < Count; index++)
				{
					yield return (setArray[index]);
				}
			}
		}


        //---------------------------------
        // Klasa wewntrzna
        //---------------------------------
		public class SubGroup : IEnumerable
		{
			//KONSTRUKTORY
			public SubGroup() {}

			public SubGroup(string name)
			{
				subGroupName = name;
			}

			//POLA
			private string subGroupName = "";
			private List<Item> itemArray = new List<Item>();

            //WACIWOCI
			public string SubGroupName
			{
				get{return(subGroupName);}
			}

			public int Count
			{
				get{return(itemArray.Count);}
			}

			//METODY
			public void AddItem(string name, int location)
			{
				Item itm = new Item(name, location);
				itemArray.Add(itm);
			}

			public Item GetSubGroup(int index)
			{
				return(itemArray[index]);
			}

			IEnumerator IEnumerable.GetEnumerator()
			{
				for (int index = 0; index < Count; index++)
				{
					yield return (itemArray[index]);
				}
			}
		}


		//-----------------------------------------
		//
        //  Klasa najniszego poziomu
		//
		//-----------------------------------------
		public class Item
		{
			//KONSTRUKTORY
			public Item(string name, int location)
			{
				itemName = name;
				itemLocation = location;
			}

			//POLA
			private string itemName = "";
			private int itemLocation = 0;

			//WACIWOCI
			public string ItemName
			{
				get {return(itemName);}
				set {itemName = value;}
			}

			public int ItemLocation
			{
				get {return(itemLocation);}
				set {itemLocation = value;}
			}
		}
		#endregion

        #region "6.2 Tworzenie wasnej obsugi ptli foreach"
        // ***   Wczeniej 3.34   ***
		public static void TestIterators()
		{
			Container<int> cntnr = new Container<int>();

			// Utworzenie danych testowych
			List<int> testData = new List<int>(10);
			testData.Add(-1);
			testData.Add(1);
			testData.Add(2);
			testData.Add(3);
			testData.Add(4);
			testData.Add(5);
			testData.Add(6);
			testData.Add(7);
			testData.Add(8);
			testData.Add(9);
			testData.Add(10);
			testData.Add(200);
			testData.Add(500);

			// Dodanie danych testowych do obiektu Container
			cntnr.List = testData;

			// Przegldanie w ptli obiektu Container
			foreach (int i in cntnr)
			{
				Console.WriteLine(i);
			}

			Console.WriteLine();
			foreach (int i in cntnr.ReverseOrder)
			{
				Console.WriteLine(i);
			}

			Console.WriteLine();
			foreach (int i in cntnr.ForwardOrderStep(2))
			{
				Console.WriteLine(i);
			}

			Console.WriteLine();
			foreach (int i in cntnr.ReverseOrderStep(3))
			{
				Console.WriteLine(i);
			}
		}

		public class Container<T>
		{
			public Container() {}


			private List<T> internalList = new List<T>();


			public List<T> List
			{
				get	{return (internalList);}
				set	{internalList = value;}
			}

            // Ten iterator przeglda w ptli elementy listy od pierwszego do ostatniego.
			public IEnumerator<T> GetEnumerator()
			{
				for (int index = 0; index < internalList.Count; index++)
				{
					yield return (internalList[index]);
				}
			}

            //  Ten iterator przeglda w ptli elementy listy od ostatniego do pierwszego.
			public IEnumerable<T> ReverseOrder
			{
				get
				{
					for (int index = internalList.Count - 1; index >= 0; index--)
					{
						yield return (internalList[index]);
					}
				}
			}

            // Ten iterator przeglda w ptli elementy listy od pierwszego do ostatniego
            // przeskakujc co predefiniowan liczb elementw.

			public IEnumerable<T> ForwardOrderStep(int step)
			{
				for (int index = 0; index < internalList.Count; index += step)
				{
					yield return (internalList[index]);
				}
			}

            // Ten iterator przeglda w ptli elementy listy od ostatniego do pierwszego
            // przeskakujc co predefiniowan liczb elementw.
            public IEnumerable<T> ReverseOrderStep(int step)
			{
				for (int index = internalList.Count - 1; index >= 0; index -= step)
				{
					yield return (internalList[index]);
				}
			}
		}
		#endregion

        #region "6.3 Tworzenie iteratorw dla typu generycznego"
        public static void TestShoppingCart()
		{
            // Utworzenie obiektu ShoppingList i wypenienie go danymi.
			ShoppingList<string> scart = new ShoppingList<string>();
            scart.AddItem("element1");
            scart.AddItem("element2");
            scart.AddItem("element3");
            scart.AddItem("element4");
            scart.AddItem("element5");
            scart.AddItem("element6");

            //  Wywietlenie wszystkich danych w obiekcie ShoppingCart.
			foreach(string t in scart)
			{
				Console.WriteLine(t);
			}
		}


		public class ShoppingList<T> : IEnumerable<T>
		{
			public ShoppingList() {}

			private List<T> _items = new List<T>();

			public void AddItem(T name)
			{
				_items.Add(name);
			}

			public IEnumerator<T> GetEnumerator()
			{
				for (int index = 0; index < _items.Count; index++)
				{
					yield return (_items[index]);
				}
			}

			IEnumerator<T> IEnumerable<T>.GetEnumerator()
			{
				for (int index = 0; index < _items.Count; index++)
				{
					yield return (_items[index]);
				}
			}

			IEnumerator IEnumerable.GetEnumerator()
			{
				for (int index = 0; index < _items.Count; index++)
				{
					yield return (_items[index]);
				}
			}
		}
		#endregion

        #region "6.4 Tworzenie iteratora dla typu niegenerycznego"
        public static void TestNGShoppingCart()
		{
            //Utworzenie obiektu NGShoppingList i wypenienie go danymi.
			NGShoppingList scart = new NGShoppingList();
			scart.AddItem("element1");
            scart.AddItem("element2");
            scart.AddItem("element3");
            scart.AddItem("element4");
            scart.AddItem("element5");
            scart.AddItem("element6");

            //  Wywietlenie wszystkich danych w obiekcie NGShoppingCart.
			foreach (string t in scart)
			{
				Console.WriteLine(t);
			}
		}


		public class NGShoppingList// : IEnumerable
		{
			public NGShoppingList() {}

			private List<string> _items = new List<string>();

			public void AddItem(string name)
			{
				_items.Add(name);
			}

			public IEnumerator GetEnumerator()
			{
				for (int index = 0; index < _items.Count; index++)
				{
					yield return (_items[index]);
				}
			}
		}
		#endregion

        #region "6.5 Tworzenie iteratorw z parametrami"
        public static void TestIteratorMethod()
		{
            //Utworzenie obiektu Foo i wypenienie go danymi.
			Foo f = new Foo();
			f.AddItem("element1");
            f.AddItem("element2");
            f.AddItem("element3");
            f.AddItem("element4");
            f.AddItem("element5");
            f.AddItem("element6");

            //  Wywietlenie wszystkich danych w obiekcie Foo.
			foreach (string s in f.GetSpecificItems(3, 4))
			{
				Console.WriteLine(s);
			}

			Console.WriteLine();
			try
			{
				foreach (string s in f.GetSpecificItems(-3, 5))
				{
					Console.WriteLine(s);
				}
			}
			catch(Exception e)
			{
				Console.WriteLine("Wystpi bd:  " + e.ToString());
			}

			Console.WriteLine();
			foreach (string s in f.GetSpecificItems(2, 40))
			{
				Console.WriteLine(s);
			}
		}


		public class Foo
		{
			private List<string> _items = new List<string>();

			public void AddItem(string item)
			{
				_items.Add(item);
			}

			public IEnumerator GetEnumerator()
			{
				for (int index = 0; index < _items.Count; index++)
				{
					yield return (_items[index]);
				}
			}

            // Iterator pobiera parametry w postaci indeksu pocztkowego i kocowego
			public IEnumerable GetSpecificItems(int start, int end)
			{
				if (start < 0)
				{
                    throw (new IndexOutOfRangeException("Indeks pocztkowy nie moe by mniejszy od zera."));
				}

				//if (end >= _items.Count)
				//{
				//    throw (new IndexOutOfRangeException
				//           ("Indeks kocowy nie moe by wikszy od cakowitej liczby elementw w obiekcie."));
				//}

				for (int index = start; (index < _items.Count) && (index <= end); index++)
				{
					yield return (_items[index]);
				}
			}
		}
		#endregion

        #region "6.6 Definiowanie wielu iteratorw dla jednego typu"
        public static void TestIteratorProperties()
		{
            //Utworzenie obiektu SimpleListIterator i wypenienie go danymi.
			SimpleListIterator b = new SimpleListIterator();
			b.AddItem("element1");
            b.AddItem("element2");
            b.AddItem("element3");
            b.AddItem("element4");
            b.AddItem("element5");
            b.AddItem("element6");
            b.AddItem("element7");
            b.AddItem("element8");

            //  Wywietlenie wszystkich danych w obiekcie SimpleListIterator.
			Console.WriteLine("\r\nIterator GetEnumerator");
			foreach (string s in b)
			{
				Console.WriteLine(s);
			}

			Console.WriteLine("\r\nIterator ReverseOrder");
			foreach (string s in b.ReverseOrder)
			{
				Console.WriteLine(s);
			}

			Console.WriteLine("\r\nIterator FirstHalf");
			foreach (string s in b.FirstHalf)
			{
				Console.WriteLine(s);
			}

			Console.WriteLine("\r\nIterator SecondHalf");
			foreach (string s in b.SecondHalf)
			{
				Console.WriteLine(s);
			}
		}


		public class SimpleListIterator
		{
			private List<string> _items = new List<string>();

			public void AddItem(string item)
			{
				_items.Add(item);
			}

			public IEnumerator GetEnumerator()
			{
				for (int index = 0; index < _items.Count; index++)
				{
					yield return (_items[index]);
				}
			}

			// Dodatkowe iteratory zaimplementowane jako metody dostpowe get waciwoci
			public IEnumerable ReverseOrder
			{
				get
				{
					for (int index = _items.Count - 1; index >= 0; index--)
					{
						yield return (_items[index]);
					}
				}
			}
			public IEnumerable FirstHalf
			{
				get
				{
					for (int index = 0; index < (_items.Count / 2); index++)
					{
						yield return (_items[index]);
					}
				}
			}
			public IEnumerable SecondHalf
			{
				get
				{
					for (int index = (_items.Count / 2); index < _items.Count; index++)
					{
						yield return (_items[index]);
					}
				}
			}
		}
		#endregion

        #region "6.7 Implementacja iteratorw jako przecionych operatorw"
        public static void TestOperatorIterator()
		{
            //Utworzenie obiektu Set<string> i wypenienie go danymi.
			Set<string> set1 = new Set<string>();
			set1.AddItem("element1");
            set1.AddItem("element11");
            set1.AddItem("element2");
            set1.AddItem("element2");
			set1.AddItem("element3");
			set1.AddItem("XYZ");

            //Utworzenie drugiego obiektu Set<string> i wypenienie go danymi.
			Set<string> set2 = new Set<string>();
			set2.AddItem("element30");
            set2.AddItem("element11");
            set2.AddItem("element11");
            set2.AddItem("element2");
            set2.AddItem("element12");
            set2.AddItem("element1");

            //  Wywietlenie wszystkich danych w obu zbiorach.
            Console.WriteLine("\r\nWywietlenie wszystkich danych w obu zbiorach.");
			foreach (string s in (set1 + set2))
			{
				Console.WriteLine(s);
			}

            // Wywietlenie niepowtarzalnych danych w obu zbiorach.
            Console.WriteLine("\r\nWywietlenie tylko niepowtarzalnych danych w obu zbiorach.");
			foreach (string s in (set1 | set2))
			{
				Console.WriteLine(s);
			}

            //  Wywietlenie wszystkich zdublowanych danych w obu zbiorach.
            Console.WriteLine("\r\n Wywietlenie wszystkich zdublowanych danych w obu zbiorach.");
			foreach (string s in (set1 & set2))
			{
				Console.WriteLine(s);
			}
		}


		public class Set<T>
		{
			private List<T> _items = new List<T>();

			public void AddItem(T name)
			{
				_items.Add(name);
			}

			public int Count
			{
				get {return (_items.Count);}
			}

			public T this[int index]
			{
				get {return (_items[index]);}
				set {_items[index] = value;}
			}

			public void Copy(Set<T> original)
			{
				foreach(T t in original)
				{
					_items.Add(t);
				}
			}

			public bool Contains(T t)
			{
				if (_items.Contains(t))
					return (true);
				else
					return (false);
			}


			// Iteratory
			public IEnumerator<T> GetEnumerator()
			{
				for (int index = 0; index < _items.Count; index++)
				{
					yield return (_items[index]);
				}
			}

			public static IEnumerable<T> operator +(Set<T> lhs, Set<T> rhs)
			{
				for (int index = 0; index < lhs.Count; index++)
				{
					yield return (lhs[index]);
				}

				for (int index = 0; index < rhs.Count; index++)
				{
					yield return (rhs[index]);
				}
			}

			public static IEnumerable<T> operator +(IEnumerable<T> lhs, Set<T> rhs)
			{
				foreach (T t in lhs)
				{
					yield return (t);
				}

				for (int index = 0; index < rhs.Count; index++)
				{
					yield return (rhs[index]);
				}
			}

			public static IEnumerable<T> operator +(Set<T> lhs, IEnumerable<T> rhs)
			{
				foreach (T t in rhs)
				{
					yield return (t);
				}

				for (int index = 0; index < lhs.Count; index++)
				{
					yield return (lhs[index]);
				}
			}

			public static IEnumerable<T> operator |(Set<T> lhs, Set<T> rhs)
			{
                // Usunicie duplikatw z obiektu lhs.
				Set<T> tempSet = new Set<T>();
				for (int index = 0; index < lhs.Count; index++)
				{
					if (!tempSet.Contains(lhs[index]))
					{
						tempSet.AddItem(lhs[index]);
					}
				}

				for (int index = 0; index < tempSet.Count; index++)
				{
					yield return (tempSet[index]);
				}

				for (int index = 0; index < rhs.Count; index++)
				{
					if (!tempSet.Contains(rhs[index]))
					{
						yield return (rhs[index]);
					}
				}
			}

			public static IEnumerable<T> operator |(IEnumerable<T> lhs, Set<T> rhs)
			{
                // Usunicie duplikatw z obiektu lhs.
				Set<T> tempSet = new Set<T>();
				foreach (T t in lhs)
				{
					if (!tempSet.Contains(t))
					{
						tempSet.AddItem(t);
					}
				}

				for (int index = 0; index < tempSet.Count; index++)
				{
					yield return (tempSet[index]);
				}

				for (int index = 0; index < rhs.Count; index++)
				{
					if (!tempSet.Contains(rhs[index]))
					{
						yield return (rhs[index]);
					}
				}
			}

			public static IEnumerable<T> operator |(Set<T> lhs, IEnumerable<T> rhs)
			{
                // Usunicie duplikatw z obiektu lhs.
				Set<T> tempSet = new Set<T>();
				foreach (T t in lhs)
				{
					if (!tempSet.Contains(t))
					{
						tempSet.AddItem(t);
					}
				}

				for (int index = 0; index < tempSet.Count; index++)
				{
					yield return (tempSet[index]);
				}

				foreach (T t in rhs)
				{
					if (!tempSet.Contains(t))
					{
						yield return (t);
					}
				}
			}

			public static IEnumerable<T> operator &(Set<T> lhs, Set<T> rhs)
			{
                // Usunicie duplikatw z obiektu lhs.
				Set<T> tempSet = new Set<T>();
				for (int index = 0; index < lhs.Count; index++)
				{
					if (!tempSet.Contains(lhs[index]))
					{
						tempSet.AddItem(lhs[index]);
					}
				}

				for (int index = 0; index < tempSet.Count; index++)
				{
					if (rhs.Contains(tempSet[index]))
					{
						yield return (tempSet[index]);
					}
				}
			}

			public static IEnumerable<T> operator &(IEnumerable<T> lhs, Set<T> rhs)
			{
                // Usunicie duplikatw z obiektu lhs.
				Set<T> tempSet = new Set<T>();
				foreach (T t in lhs)
				{
					if (!tempSet.Contains(t))
					{
						tempSet.AddItem(t);
					}
				}

				for (int index = 0; index < tempSet.Count; index++)
				{
					if (rhs.Contains(tempSet[index]))
					{
						yield return (tempSet[index]);
					}
				}
			}

			public static IEnumerable<T> operator &(Set<T> lhs, IEnumerable<T> rhs)
			{
                // Usunicie duplikatw z obiektu lhs.
				Set<T> tempSet = new Set<T>();
				for (int index = 0; index < lhs.Count; index++)
				{
					if (!tempSet.Contains(lhs[index]))
					{
						tempSet.AddItem(lhs[index]);
					}
				}

				foreach (T t in rhs)
				{
					if (tempSet.Contains(t))
					{
						yield return (t);
					}
				}
			}
		}
		#endregion

        #region "6.8 Wymuszone zatrzymywanie iteratora"
        public static void TestYieldBreak()
		{
			//Utworzenie obiektu Baz i wypenienie go danymi
			Baz b = new Baz();
			b.AddItem("element1");
            b.AddItem("element2");
            b.AddItem("element3");
            b.AddItem("element4");
            b.AddItem("element5");
            b.AddItem("element6");

			// Wywietlenie wszystkich danych w obiekcie Baz
			Console.WriteLine();
			try
			{
				foreach (string s in b)
				{
					Console.WriteLine(s);
				}
			}
			catch (Exception e)
			{
				Console.WriteLine(e.Message);
			}
		}


		public class Baz
		{
			private List<string> _items = new List<string>();
			private bool noMoreItemsCanBeAdded = false;
			private int upperLimit = 3;

			public int UpperLimit
			{
				get {return (upperLimit);}
				set {upperLimit = value;}
			}

			public void AddItem(string name)
			{
				_items.Add(name);
			}

			public IEnumerator GetEnumerator()
			{
				for (int index = 0; index < _items.Count; index++)
				{
					if (noMoreItemsCanBeAdded)
					{
						// Operacje zgaszania wyjtkw s kosztowne, zastosowanie konstrukcji yield break
						//throw (new Exception("Nie mona doda wicej elementw."));
						yield break;
					}
					else
					{
						// Wykonanie dziaa, ktre mog ustawi noMoreItemsCanBeAdded na warto true
						if (index >= upperLimit)
						{
							noMoreItemsCanBeAdded = true;
						}

						yield return (_items[index]);
					}
				}
			}
		}
		#endregion

        #region "6.9 Obsuga bloku finally w iteratorach"
        public static void TestFinallyAndIterators()
		{
			// Utworzenie obiektu StringSet i wypenienie go danymi
			StringSet strSet = new StringSet();
			strSet.AddString("element1");
            strSet.AddString("element2");
            strSet.AddString("element3");
            strSet.AddString("element4");
            strSet.AddString("element5");
            strSet.AddString("element6");

			// Wywietlenie wszystkich danych w obiekcie StringSet
			try
			{
				foreach (string s in strSet)
				{
					try
					{
						// Wymuszony wyjtek
						//int n;
						//for (int i = 0; i < 2;i++)
						//    n = 1/i;

						Console.WriteLine(s);
					}
					catch (Exception)
					{
						Console.WriteLine("W bloku catch ptli foreach");
					}
					finally
					{
						// Wykonywana w kadej iteracji
						Console.WriteLine("W bloku finally ptli foreach");
					}
				}
			}
			catch (Exception)
			{
				Console.WriteLine("W zewntrznym bloku catch");
			}
			finally
			{
                // Wykonywana w kadej iteracji
				Console.WriteLine("W zewntrznym bloku finally");
			}

            /*
            Ten kod wykona si w poniszy sposb, kiedy wystpi wyjtek w iteratorze:
             - W bloku finally iteratora
             - W zewntrznym bloku catch
             - W zewntrznym bloku finally

            Ten kod wykona si w poniszy sposb, kiedy NIE wystpi wyjtek w iteratorze:
             - element1
             - W bloku finally ptli foreach
             - element2
             - W bloku finally ptli foreach
             - element3
             - W bloku finally ptli foreach
             - element4
             - W bloku finally ptli foreach
             - element5
             - W bloku finally ptli foreach
             - element6
             - W bloku finally ptli foreach
             - W bloku finally wewntrz iteratora
             - W zewntrznym bloku finally

            Ten kod wykona si w poniszy sposb, kiedy wystpi wyjtek w ptli foreach:
             - W bloku catch ptli foreach
             - W bloku finally ptli foreach
             - W bloku catch ptli foreach
             - W bloku finally ptli foreach
             - W bloku catch ptli foreach
             - W bloku finally ptli foreach
             - W bloku catch ptli foreach
             - W bloku finally ptli foreach
             - W bloku catch ptli foreach
             - W bloku finally ptli foreach
             - W bloku catch ptli foreach
             - W bloku finally ptli foreach
             - W bloku finally iteratora
             - W zewntrznym bloku finally
            */
        }


		public class StringSet
		{
			private List<string> _items = new List<string>();

			public void AddString(string str)
			{
				_items.Add(str);
			}

			public IEnumerator GetEnumerator()
			{
				try
				{
					for (int index = 0; index < _items.Count; index++)
					{
						//Wymuszony wyjtek
						//int n = 1 / index;
						yield return (_items[index]);
					}
				}
				// Nie mona uywa blokw catch w iteratorze
				finally
				{
					// Wykona si tylko na kocu ptli foreach (wcznie z yield break)
					Console.WriteLine("W bloku finally wewntrz iteratora");
				}
			}
		}
		#endregion

        #region "6.10 Organizacja implementacji interfejsw"
        // Patrz projekt "PartialClassInterface"
		#endregion

        #region "6.11 Generowanie kodu spoza gwnej cieki"
        // patrz projekt "PartialClassAddin"
		#endregion
	}
}
